package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.FastNonFastEnumeration;

@XmlRootElement(name = "LipidsReadingDTO")
public class LipidsReadingDTO extends AbstractDTO implements Serializable{

	private static final long serialVersionUID = 380247108902380574L;
	private Long lipidsId;
	private FastNonFastEnumeration fast = FastNonFastEnumeration.F;
	private BigDecimal total;
	private BigDecimal hdl;
	private BigDecimal ldl;
	private BigDecimal triglycerides;
	private String location;
	private String provider;
	private String comments;
	private Long userprofileId;
	public Long getLipidsId() {
		return lipidsId;
	}
	public void setLipidsId(Long lipidsId) {
		this.lipidsId = lipidsId;
	}
	public String getFast() {
		return fast.name();
	}
	public void setFast(String fast) {
		this.fast = FastNonFastEnumeration.valueOf(fast);
	}
	public BigDecimal getTotal() {
		return total;
	}
	public void setTotal(BigDecimal total) {
		this.total = total;
	}
	public BigDecimal getHdl() {
		return hdl;
	}
	public void setHdl(BigDecimal hdl) {
		this.hdl = hdl;
	}
	public BigDecimal getLdl() {
		return ldl;
	}
	public void setLdl(BigDecimal ldl) {
		this.ldl = ldl;
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getProvider() {
		return provider;
	}
	public void setProvider(String provider) {
		this.provider = provider;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	public BigDecimal getTriglycerides() {
		return triglycerides;
	}
	public void setTriglycerides(BigDecimal triglycerides) {
		this.triglycerides = triglycerides;
	}
	@JsonIgnore
	public String getDisplayFast() {
		return this.fast.getDescription();
	}
	@JsonIgnore
	public FastNonFastEnumeration[] getFastNonFast() {
		return FastNonFastEnumeration.values();
	}
}
